//
//  AppDelegate.m
//  Listening for Notifications Sent From NSNotificationCenter
//
//  Created by Vandad Nahavandipoor on 19/08/2011.
//  Copyright (c) 2011 Pixolity Ltd. All rights reserved.
//

#import "AppDelegate.h"

@implementation AppDelegate

@synthesize window = _window;

/* Nazwa powiadomienia. */
const NSString *ResultOfAppendingTwoStringsNotification = 
                @"ResultOfAppendingTwoStringsNotification";

/* Klucze w słowniku wysyłanym przez powiadomienie. */
const NSString 
  *ResultOfAppendingTwoStringsFirstStringInfoKey = @"firstString";

const NSString 
  *ResultOfAppendingTwoStringsSecondStringInfoKey = @"secondString";

const NSString 
  *ResultOfAppendingTwoStringsResultStringInfoKey = @"resultString";

- (void) broadcastNotification{
  
  NSString *firstName = @"Jan";
  NSString *lastName = @"Kowalski";
  NSString *fullName = [firstName stringByAppendingString:lastName];
  
  NSArray *objects = [[NSArray alloc] initWithObjects:
                      firstName,
                      lastName,
                      fullName,
                      nil];
  
  NSArray *keys = [[NSArray alloc] initWithObjects:
                   ResultOfAppendingTwoStringsFirstStringInfoKey,
                   ResultOfAppendingTwoStringsSecondStringInfoKey,
                   ResultOfAppendingTwoStringsResultStringInfoKey,
                   nil];
  
  NSDictionary *userInfo = [[NSDictionary alloc] initWithObjects:objects
                                                         forKeys:keys];
  
  NSNotification *notificationObject = 
  [NSNotification 
   notificationWithName:(NSString *)ResultOfAppendingTwoStringsNotification
   object:self
   userInfo:userInfo];
  
  [[NSNotificationCenter defaultCenter] postNotification:notificationObject];
  
}

- (void) appendingIsFinished:(NSNotification *)paramNotification{
  
  NSLog(@"Otrzymano powiadomienie.");
  NSLog(@"Obiekt powiadomienia = %@", [paramNotification object]);
  NSLog(@"Słownik userInfo powiadomienia = %@", [paramNotification userInfo]);
  
}

- (BOOL)            application:(UIApplication *)application 
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  
  /* Nasłuchiwanie powiadomień. */
  [[NSNotificationCenter defaultCenter] 
   addObserver:self
   selector:@selector(appendingIsFinished:) 
   name:(NSString *)ResultOfAppendingTwoStringsNotification
   object:self];
  
  [self broadcastNotification];
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
  
}

- (void)applicationWillTerminate:(UIApplication *)application{
  /* Nie chcemy dłużej otrzymywać ŻADNYCH powiadomień. */
  [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

@end
